
;
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;		AS IN 3.3.12.0 ....            note the ? marks in the iWparam statements ... BUT MAINLY the "If $hFile - 1 Then ..." statement
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

; #FUNCTION# ====================================================================================================================
; Authors........: Chris Haslam (c.haslam)
; Modified ......:
; ===============================================================================================================================
Func _GUICtrlRichEdit_StreamToFile($hWnd, $sFilespec, $bIncludeCOM = True, $iOpts = 0, $iCodePage = 0)
	If Not _WinAPI_IsClassName($hWnd, $__g_sRTFClassName) Then Return SetError(101, 0, False)

	Local $iWparam
	If StringRight($sFilespec, 4) = ".rtf" Then
		$iWparam = ($bIncludeCOM ? $SF_RTF : $SF_RTFNOOBJS)
	Else
		$iWparam = ($bIncludeCOM ? $SF_TEXTIZED : $SF_TEXT)
		If BitAND($iOpts, $SFF_PLAINRTF) Then Return SetError(1041, 0, False)
	EndIf
	; only opts are $SFF_PLAINRTF and $SF_UNICODE
	If BitAND($iOpts, BitNOT(BitOR($SFF_PLAINRTF, $SF_UNICODE))) Then Return SetError(1042, 0, False)
	If BitAND($iOpts, $SF_UNICODE) Then
		If Not BitAND($iWparam, $SF_TEXT) Then Return SetError(1043, 0, False)
	EndIf

	If _GUICtrlRichEdit_IsTextSelected($hWnd) Then $iWparam = BitOR($iWparam, $SFF_SELECTION)

	$iWparam = BitOR($iWparam, $iOpts)
	If $iCodePage <> 0 Then
		$iWparam = BitOR($iWparam, $SF_USECODEPAGE, BitShift($iCodePage, -16))
	EndIf
	Local $tEditStream = DllStructCreate($tagEDITSTREAM)
	DllStructSetData($tEditStream, "pfnCallback", DllCallbackGetPtr($__g_pGRC_StreamToFileCallback))
	Local $hFile = FileOpen($sFilespec, $FO_OVERWRITE)
	If $hFile - 1 Then Return SetError(102, 0, False)										;<<<<<<<<<<<<<<<<<<<<<<<<<<< problem

	DllStructSetData($tEditStream, "dwCookie", $hFile) ; -> Send handle to CallbackFunc
	_SendMessage($hWnd, $EM_STREAMOUT, $iWparam, $tEditStream, 0, "wparam", "struct*")
	FileClose($hFile)
	Local $iError = DllStructGetData($tEditStream, "dwError")
	If $iError <> 0 Then SetError(700, $iError, False)
	Return True
EndFunc   ;==>_GUICtrlRichEdit_StreamToFile


;
; AS IT WAS IN 3.3.8.1 ... for reference <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
;
; #FUNCTION# ====================================================================================================================
; Name ..........: _GUICtrlRichEdit_StreamToFile
; Description....: Writes contens of a control to a file
; Syntax ........: _GUICtrlRichEdit_StreamToFile($hWnd, $sFilespec[, $fIncludeCOM=True[, $iOpts=0[, $iCodePage = 0]]])
; Parameters.....: $hWnd		- Handle to the control
;                  $sFileSpec - file specification
;                  $fIncludeCOM - (Optional)
;                  |True (default):
;                  |    If writing to a .rtf file, includes any COM objects (space consuming)
;                  |    If writing to any other file, writes a text represntation of COM objects
;                  |False: Writes spaces instead of COM objects
;                  $iOpts - additional options: (Optional) (default: 0)
;                  |$SFF_PLAINTRTF - write only rich text keywords common to all languages
;                  |$SF_UNICODE    - write Unicode
;                  $iCodePage - Generate UTF-8 and text using this code page (Optional)
;                  |Default: do not
; Return values..: Success - True
;                  Failure - False and sets @error:
;                  |101  - $hWnd is not a handle
;                  |102  - Can't create $sFilespec
;                  |1041 - $SFF_PLAINRTF is invalid for a text file
;                  |1042 - $opts: invalid option
;                  |1043 - $SF_UNICODE is only valid for a text file
;                  |700  - internal error
; Authors........: Chris Haslam (c.haslam)
; Modified ......:
; Remarks .......: If text is selected, writes only the selection, else writes all text in the control
;+
;                  If the extension in $sFileSpec is .rtf, RTF is written, else text
; Related .......: _GUICtrlRichEdit_SetLimitOnText, _GUICtrlRichEdit_StreamFromVar, _GUICtrlRichEdit_StreamToFile
; Link ..........: @@MsdnLink@@ EM_STREAMIN
; Example .......: Yes
; ===============================================================================================================================
Func _GUICtrlRichEdit_StreamToFile($hWnd, $sFilespec, $fIncludeCOM = True, $iOpts = 0, $iCodePage = 0)
	If Not _WinAPI_IsClassName($hWnd, $_GRE_sRTFClassName) Then Return SetError(101, 0, False)

	Local $iWparam
	If StringRight($sFilespec, 4) = ".rtf" Then
		$iWparam = _Iif($fIncludeCOM, $SF_RTF, $SF_RTFNOOBJS)
	Else
		$iWparam = _Iif($fIncludeCOM, $SF_TEXTIZED, $SF_TEXT)
		If BitAND($iOpts, $SFF_PLAINRTF) Then Return SetError(1041, 0, False)
	EndIf
	; only opts are $SFF_PLAINRTF and $SF_UNICODE
	If BitAND($iOpts, BitNOT(BitOR($SFF_PLAINRTF, $SF_UNICODE))) Then Return SetError(1042, 0, False)
	If BitAND($iOpts, $SF_UNICODE) Then
		If Not BitAND($iWparam, $SF_TEXT) Then Return SetError(1043, 0, False)
	EndIf

	If _GUICtrlRichEdit_IsTextSelected($hWnd) Then $iWparam = BitOR($iWparam, $SFF_SELECTION)

	$iWparam = BitOR($iWparam, $iOpts)
	If $iCodePage <> 0 Then
		$iWparam = BitOR($iWparam, $SF_USECODEPAGE, BitShift($iCodePage, -16))
	EndIf
	Local $tEditStream = DllStructCreate($tagEDITSTREAM)
	DllStructSetData($tEditStream, "pfnCallback", DllCallbackGetPtr($_GRC_StreamToFileCallback))
	Local $hFile = FileOpen($sFilespec, 2) ; overwrite
	If $hFile - 1 Then Return SetError(102, 0, False)

	DllStructSetData($tEditStream, "dwCookie", $hFile) ; -> Send handle to CallbackFunc
	_SendMessage($hWnd, $EM_STREAMOUT, $iWparam, $tEditStream, 0, "wparam", "struct*")
	FileClose($hFile)
	Local $iError = DllStructGetData($tEditStream, "dwError")
	If $iError <> 0 Then SetError(700, $iError, False)
	Return True
EndFunc   ;==>_GUICtrlRichEdit_StreamToFile

